ORCA/M Asm65816 2.1.0

0001 7B69              ****************************************************************
0002 7B69              *                                                              *
0003 7B69              *                    Common Strip Routines                     *
0004 7B69              *                        Version 1.0                           *
0005 7B69              *                       August 13, 1986                        *
0006 7B69              *                                                              *
0007 7B69              ****************************************************************
0008 7B69
0009 7B69
0010 7B69              ****************************************************************
0011 7B69              *                                                              *
0012 7B69              *                   Copyright (C) 1985-1988                    *
0013 7B69              *                   All Rights Reserved                        *
0014 7B69              *                   Apple Computer, Inc.                       *
0015 7B69              *                                                              *
0016 7B69              ****************************************************************
0017 7B69
0018 7B69              ****************************************************************
0019 7B69              *
0020 7B69              * EndCall Routines.
0021 7B69              *
0022 7B69              * Functions exit through the EndCall routines.  These routines
0023 7B69              * fix the stack by moving the RTL addresses up and stripping
0024 7B69              * off any input parameters.
0025 7B69              *
0026 7B69              * The number of bytes to strip off the stack is passed in the
0027 7B69              * y-register.
0028 7B69              *
0029 7B69              * There are 8 end call routines
0030 7B69              *
0031 7B69              *       EndCall        Pulls D off stack before cleaning up.  Sets
0032 7B69              *                      a-reg to zero and clears carry.
0033 7B69              *       oEndCall       Does not pull D off the stack before
0034 7B69              *                      cleaning up.  Sets a-reg to zero and clears
0035 7B69              *                      carry.
0036 7B69              *       ErrOut         Pulls D off stack, cleans up and returns
0037 7B69              *                      error code passed in x-register, setting
0038 7B69              *                      carry if x is not zero.
0039 7B69              *       oErrOut        Does not pull D off stack before cleaning up.
0040 7B69              *                      returns error code passed in x-register,
0041 7B69              *                      setting carry if x is not zero.
0042 7B69              *
0043 7B69              *       BusyEC         Decrements the busy flag, pulls D off stack
0044 7B69              *                      and cleans up.
0045 7B69              *       oBusyEC        Decrements the busy flag, does not pull D off stack
0046 7B69              *                      and cleans up.
0047 7B69              *       BusyErr        Decrements the busy flag, pulls D off stack,
0048 7B69              *                      cleans up and returns error code passed in
0049 7B69              *                      x-register, setting the carry if x is not zero.
0050 7B69              *       oBusyErr       Decrements the busy flag, does not pull D off
0051 7B69              *                      the stack, cleans up and returns error code passed
0052 7B69              *                      in x-register.
0053 7B69              *
0054 7B69              ****************************************************************
0055 7B69              Strip    PROC 
0056 7B69              IncBusyFlg equ   $E10064
0057 7B69              DecBusyFlg equ   $E10068
0058 7B69
0059 7B69                       EXPORT BusyEC 
0060 7B69              BusyEC    
0061 7B69 A2 00 00              ldx   #0
0062 7B6C
0063 7B6C                       EXPORT BusyErr 
0064 7B6C              BusyErr   
0065 7B6C 22 68 00 E1           jsl   DecBusyFlg
0066 7B70 80 03                 bra   ErrOut
0067 7B72
0068 7B72                       EXPORT EndCall 
0069 7B72              EndCall   
0070 7B72 A2 00 00              ldx   #0
0071 7B75
0072 7B75                       EXPORT ErrOut 
0073 7B75              ErrOut    
0074 7B75 2B                    pld                            ; restore direct register
0075 7B76
0076 7B76                       EXPORT oErrOut 
0077 7B76              oErrOut   
0078 7B76 5A                    phy                            ; save amount to strip on stack
0079 7B77 3B                    tsc                            ; get stack pointer
0080 7B78 18                    clc                            ; add to it the amount to strip
0081 7B79 63 01                 adc   1,s
0082 7B7B A8                    tay                            ; put this result in Y
0083 7B7C 3B                    tsc                            ; get back orig stack pointer
0084 7B7D DA                    phx                            ; save error on stack
0085 7B7E AA                    tax                            ; put orig stack in X
0086 7B7F 8B                    phb                            ; now save the data bank reg
0087 7B80 F4 00 00              pea   $0000                    ; set data bank reg to 0
0088 7B83 AB                    plb   
0089 7B84 AB                    plb   
0090 7B85 BD 07 00              lda   |3+4,x                   ; now use x and y to move 6 bytes
0091 7B88 99 07 00              sta   |3+4,y                   ; of rtl info from current pos
0092 7B8B BD 05 00              lda   |3+2,x                   ; to final pos.
0093 7B8E 99 05 00              sta   |3+2,y
0094 7B91 BD 03 00              lda   |3+0,x
0095 7B94 99 03 00              sta   |3+0,y
0096 7B97 AB                    plb                            ; restore data bank register
0097 7B98 FA                    plx                            ; restore x register with error
0098 7B99
0099 7B99 3B                    tsc                            ; get stack again
0100 7B9A 18                    clc                            ; bump it by amount to strip Plus 2
0101 7B9B 63 01                 adc   1,s                      ; to make up for amount to strip
0102 7B9D 69 02 00              adc   #2                       ; still on stack
0103 7BA0 1B                    tcs                            ; reset stack pointer
0104 7BA1 8A                    txa                            ; error into a-reg
0105 7BA2 C9 01 00              cmp   #1                       ; set carry correctly
0106 7BA5 6B                    rtl                            ; fini
0107 7BA6
0108 7BA6                       EXPORT oBusyEC 
0109 7BA6              oBusyEC   
0110 7BA6 A2 00 00              ldx   #0
0111 7BA9
0112 7BA9                       EXPORT oBusyErr 
0113 7BA9              oBusyErr  
0114 7BA9 22 68 00 E1           jsl   DecBusyFlg
0115 7BAD 80 C7                 bra   oErrOut
0116 7BAF
0117 7BAF                       EXPORT oEndCall 
0118 7BAF              oEndCall  
0119 7BAF A2 00 00              ldx   #0
0120 7BB2 80 C2                 bra   oErrOut
0121 7BB4
0122 7BB4                       ENDP 
0123 7BB4
0124 7BB4
0125 7BB4
0126 7BB4
0127 7BB4
0128 7BB4              oEndCalls PROC EXPORT 
0129 7BB4
0130 7BB4                       EXPORT oEndCall0 
0131 7BB4                       EXPORT oEndCall2 
0132 7BB4                       EXPORT oEndCall4 
0133 7BB4                       EXPORT oEndCall6 
0134 7BB4                       EXPORT oEndCall8 
0135 7BB4                       EXPORT oEndCall10 
0136 7BB4                       EXPORT oEndCall12 
0137 7BB4                       EXPORT oENDCall14 
0138 7BB4                       EXPORT oEndCall16 
0139 7BB4
0140 7BB4
0141 7BB4
0142 7BB4              oEndCall0  
0143 7BB4 A0 00 00              ldy   #0
0144 7BB7 5C AF 7E 02           jml   oEndCall
0145 7BBB              oEndCall2  
0146 7BBB A0 02 00              ldy   #2
0147 7BBE 5C AF 7E 02           jml   oEndCall
0148 7BC2              oEndCall4  
0149 7BC2 A0 04 00              ldy   #4
0150 7BC5 5C AF 7E 02           jml   oEndCall
0151 7BC9              oEndCall6  
0152 7BC9 A0 06 00              ldy   #6
0153 7BCC 5C AF 7E 02           jml   oEndCall
0154 7BD0              oEndCall8  
0155 7BD0 A0 08 00              ldy   #8
0156 7BD3 5C AF 7E 02           jml   oEndCall
0157 7BD7              oEndCall10  
0158 7BD7 A0 0A 00              ldy   #10
0159 7BDA 5C AF 7E 02           jml   oEndCall
0160 7BDE              oEndCall12  
0161 7BDE A0 0C 00              ldy   #12
0162 7BE1 5C AF 7E 02           jml   oEndCall
0163 7BE5              oENDCall14  
0164 7BE5 A0 0E 00              ldy   #14
0165 7BE8 5C AF 7E 02           jml   oEndCall
0166 7BEC              oEndCall16  
0167 7BEC A0 10 00              ldy   #16
0168 7BEF 5C AF 7E 02           jml   oEndCall
0169 7BF3
0170 7BF3
0171 7BF3                       ENDP 
0172 7BF3
0173 7BF3
0174 7BF3              EndCalls PROC EXPORT 
0175 7BF3
0176 7BF3                       EXPORT EndCall0 
0177 7BF3                       EXPORT EndCall2 
0178 7BF3                       EXPORT EndCall4 
0179 7BF3                       EXPORT EndCall6 
0180 7BF3                       EXPORT EndCall8 
0181 7BF3                       EXPORT EndCall10 
0182 7BF3                       EXPORT EndCall12 
0183 7BF3                       EXPORT EndCall14 
0184 7BF3                       EXPORT EndCall16 
0185 7BF3
0186 7BF3
0187 7BF3
0188 7BF3              EndCall0  
0189 7BF3 A0 00 00              ldy   #0
0190 7BF6 5C 72 7E 02           jml   EndCall
0191 7BFA              EndCall2  
0192 7BFA A0 02 00              ldy   #2
0193 7BFD 5C 72 7E 02           jml   EndCall
0194 7C01              EndCall4  
0195 7C01 A0 04 00              ldy   #4
0196 7C04 5C 72 7E 02           jml   EndCall
0197 7C08              EndCall6  
0198 7C08 A0 06 00              ldy   #6
0199 7C0B 5C 72 7E 02           jml   EndCall
0200 7C0F              EndCall8  
0201 7C0F A0 08 00              ldy   #8
0202 7C12 5C 72 7E 02           jml   EndCall
0203 7C16              EndCall10  
0204 7C16 A0 0A 00              ldy   #10
0205 7C19 5C 72 7E 02           jml   EndCall
0206 7C1D              EndCall12  
0207 7C1D A0 0C 00              ldy   #12
0208 7C20 5C 72 7E 02           jml   EndCall
0209 7C24              EndCall14  
0210 7C24 A0 0E 00              ldy   #14
0211 7C27 5C 72 7E 02           jml   EndCall
0212 7C2B              EndCall16  
0213 7C2B A0 10 00              ldy   #16
0214 7C2E 5C 72 7E 02           jml   EndCall
0215 7C32
0216 7C32
0217 7C32                       ENDP 
0218 7C32
0219 7C32
0220 7C32              oErrOuts PROC EXPORT 
0221 7C32
0222 7C32                       EXPORT oErrOut0 
0223 7C32                       EXPORT oErrOut2 
0224 7C32                       EXPORT oErrOut4 
0225 7C32                       EXPORT oErrOut6 
0226 7C32                       EXPORT oErrOut8 
0227 7C32                       EXPORT oErrOut10 
0228 7C32                       EXPORT oErrOut12 
0229 7C32                       EXPORT oErrOut14 
0230 7C32                       EXPORT oErrOut16 
0231 7C32
0232 7C32
0233 7C32
0234 7C32              oErrOut0  
0235 7C32 A0 00 00              ldy   #0
0236 7C35 5C 76 7E 02           jml   oErrOut
0237 7C39              oErrOut2  
0238 7C39 A0 02 00              ldy   #2
0239 7C3C 5C 76 7E 02           jml   oErrOut
0240 7C40              oErrOut4  
0241 7C40 A0 04 00              ldy   #4
0242 7C43 5C 76 7E 02           jml   oErrOut
0243 7C47              oErrOut6  
0244 7C47 A0 06 00              ldy   #6
0245 7C4A 5C 76 7E 02           jml   oErrOut
0246 7C4E              oErrOut8  
0247 7C4E A0 08 00              ldy   #8
0248 7C51 5C 76 7E 02           jml   oErrOut
0249 7C55              oErrOut10  
0250 7C55 A0 0A 00              ldy   #10
0251 7C58 5C 76 7E 02           jml   oErrOut
0252 7C5C              oErrOut12  
0253 7C5C A0 0C 00              ldy   #12
0254 7C5F 5C 76 7E 02           jml   oErrOut
0255 7C63              oErrOut14  
0256 7C63 A0 0E 00              ldy   #14
0257 7C66 5C 76 7E 02           jml   oErrOut
0258 7C6A              oErrOut16  
0259 7C6A A0 10 00              ldy   #16
0260 7C6D 5C 76 7E 02           jml   oErrOut
0261 7C71
0262 7C71
0263 7C71                       ENDP 
0264 7C71
0265 7C71
0266 7C71              ErrOuts  PROC EXPORT 
0267 7C71
0268 7C71                       EXPORT ErrOut0 
0269 7C71                       EXPORT ErrOut2 
0270 7C71                       EXPORT ErrOut4 
0271 7C71                       EXPORT ErrOut6 
0272 7C71                       EXPORT ErrOut8 
0273 7C71                       EXPORT ErrOut10 
0274 7C71                       EXPORT ErrOut12 
0275 7C71                       EXPORT ErrOut14 
0276 7C71                       EXPORT ErrOut16 
0277 7C71
0278 7C71
0279 7C71
0280 7C71              ErrOut0   
0281 7C71 A0 00 00              ldy   #0
0282 7C74 5C 75 7E 02           jml   ErrOut
0283 7C78              ErrOut2   
0284 7C78 A0 02 00              ldy   #2
0285 7C7B 5C 75 7E 02           jml   ErrOut
0286 7C7F              ErrOut4   
0287 7C7F A0 04 00              ldy   #4
0288 7C82 5C 75 7E 02           jml   ErrOut
0289 7C86              ErrOut6   
0290 7C86 A0 06 00              ldy   #6
0291 7C89 5C 75 7E 02           jml   ErrOut
0292 7C8D              ErrOut8   
0293 7C8D A0 08 00              ldy   #8
0294 7C90 5C 75 7E 02           jml   ErrOut
0295 7C94              ErrOut10  
0296 7C94 A0 0A 00              ldy   #10
0297 7C97 5C 75 7E 02           jml   ErrOut
0298 7C9B              ErrOut12  
0299 7C9B A0 0C 00              ldy   #12
0300 7C9E 5C 75 7E 02           jml   ErrOut
0301 7CA2              ErrOut14  
0302 7CA2 A0 0E 00              ldy   #14
0303 7CA5 5C 75 7E 02           jml   ErrOut
0304 7CA9              ErrOut16  
0305 7CA9 A0 10 00              ldy   #16
0306 7CAC 5C 75 7E 02           jml   ErrOut
0307 7CB0
0308 7CB0
0309 7CB0                       ENDP 
0310 7CB0
0311 7CB0
0312 7CB0              oBusyECs PROC EXPORT 
0313 7CB0
0314 7CB0                       EXPORT oBusyEC0 
0315 7CB0                       EXPORT oBusyEC2 
0316 7CB0                       EXPORT oBusyEC4 
0317 7CB0                       EXPORT oBusyEC6 
0318 7CB0                       EXPORT oBusyEC8 
0319 7CB0                       EXPORT oBusyEC10 
0320 7CB0                       EXPORT oBusyEC12 
0321 7CB0                       EXPORT oBusyEC14 
0322 7CB0                       EXPORT oBusyEC16 
0323 7CB0
0324 7CB0
0325 7CB0
0326 7CB0              oBusyEC0  
0327 7CB0 A0 00 00              ldy   #0
0328 7CB3 5C A6 7E 02           jml   oBusyEC
0329 7CB7              oBusyEC2  
0330 7CB7 A0 02 00              ldy   #2
0331 7CBA 5C A6 7E 02           jml   oBusyEC
0332 7CBE              oBusyEC4  
0333 7CBE A0 04 00              ldy   #4
0334 7CC1 5C A6 7E 02           jml   oBusyEC
0335 7CC5              oBusyEC6  
0336 7CC5 A0 06 00              ldy   #6
0337 7CC8 5C A6 7E 02           jml   oBusyEC
0338 7CCC              oBusyEC8  
0339 7CCC A0 08 00              ldy   #8
0340 7CCF 5C A6 7E 02           jml   oBusyEC
0341 7CD3              oBusyEC10  
0342 7CD3 A0 0A 00              ldy   #10
0343 7CD6 5C A6 7E 02           jml   oBusyEC
0344 7CDA              oBusyEC12  
0345 7CDA A0 0C 00              ldy   #12
0346 7CDD 5C A6 7E 02           jml   oBusyEC
0347 7CE1              oBusyEC14  
0348 7CE1 A0 0E 00              ldy   #14
0349 7CE4 5C A6 7E 02           jml   oBusyEC
0350 7CE8              oBusyEC16  
0351 7CE8 A0 10 00              ldy   #16
0352 7CEB 5C A6 7E 02           jml   oBusyEC
0353 7CEF
0354 7CEF
0355 7CEF                       ENDP 
0356 7CEF
0357 7CEF
0358 7CEF              BusyECs  PROC EXPORT 
0359 7CEF
0360 7CEF                       EXPORT BusyEC0 
0361 7CEF                       EXPORT BusyEC2 
0362 7CEF                       EXPORT BusyEC4 
0363 7CEF                       EXPORT BusyEC6 
0364 7CEF                       EXPORT BusyEC8 
0365 7CEF                       EXPORT BusyEC10 
0366 7CEF                       EXPORT BusyEC12 
0367 7CEF                       EXPORT BusyEC14 
0368 7CEF                       EXPORT BusyEC16 
0369 7CEF
0370 7CEF
0371 7CEF
0372 7CEF              BusyEC0   
0373 7CEF A0 00 00              ldy   #0
0374 7CF2 5C 69 7E 02           jml   BusyEC
0375 7CF6              BusyEC2   
0376 7CF6 A0 02 00              ldy   #2
0377 7CF9 5C 69 7E 02           jml   BusyEC
0378 7CFD              BusyEC4   
0379 7CFD A0 04 00              ldy   #4
0380 7D00 5C 69 7E 02           jml   BusyEC
0381 7D04              BusyEC6   
0382 7D04 A0 06 00              ldy   #6
0383 7D07 5C 69 7E 02           jml   BusyEC
0384 7D0B              BusyEC8   
0385 7D0B A0 08 00              ldy   #8
0386 7D0E 5C 69 7E 02           jml   BusyEC
0387 7D12              BusyEC10  
0388 7D12 A0 0A 00              ldy   #10
0389 7D15 5C 69 7E 02           jml   BusyEC
0390 7D19              BusyEC12  
0391 7D19 A0 0C 00              ldy   #12
0392 7D1C 5C 69 7E 02           jml   BusyEC
0393 7D20              BusyEC14  
0394 7D20 A0 0E 00              ldy   #14
0395 7D23 5C 69 7E 02           jml   BusyEC
0396 7D27              BusyEC16  
0397 7D27 A0 10 00              ldy   #16
0398 7D2A 5C 69 7E 02           jml   BusyEC
0399 7D2E
0400 7D2E
0401 7D2E                       ENDP 
0402 7D2E
0403 7D2E
0404 7D2E              oBusyErrs PROC EXPORT 
0405 7D2E
0406 7D2E                       EXPORT oBusyErr0 
0407 7D2E                       EXPORT oBusyErr2 
0408 7D2E                       EXPORT oBusyErr4 
0409 7D2E                       EXPORT oBusyErr6 
0410 7D2E                       EXPORT oBusyErr8 
0411 7D2E                       EXPORT oBusyErr10 
0412 7D2E                       EXPORT oBusyErr12 
0413 7D2E                       EXPORT oBusyErr14 
0414 7D2E                       EXPORT oBusyErr16 
0415 7D2E
0416 7D2E
0417 7D2E
0418 7D2E              oBusyErr0  
0419 7D2E A0 00 00              ldy   #0
0420 7D31 5C A9 7E 02           jml   oBusyErr
0421 7D35              oBusyErr2  
0422 7D35 A0 02 00              ldy   #2
0423 7D38 5C A9 7E 02           jml   oBusyErr
0424 7D3C              oBusyErr4  
0425 7D3C A0 04 00              ldy   #4
0426 7D3F 5C A9 7E 02           jml   oBusyErr
0427 7D43              oBusyErr6  
0428 7D43 A0 06 00              ldy   #6
0429 7D46 5C A9 7E 02           jml   oBusyErr
0430 7D4A              oBusyErr8  
0431 7D4A A0 08 00              ldy   #8
0432 7D4D 5C A9 7E 02           jml   oBusyErr
0433 7D51              oBusyErr10  
0434 7D51 A0 0A 00              ldy   #10
0435 7D54 5C A9 7E 02           jml   oBusyErr
0436 7D58              oBusyErr12  
0437 7D58 A0 0C 00              ldy   #12
0438 7D5B 5C A9 7E 02           jml   oBusyErr
0439 7D5F              oBusyErr14  
0440 7D5F A0 0E 00              ldy   #14
0441 7D62 5C A9 7E 02           jml   oBusyErr
0442 7D66              oBusyErr16  
0443 7D66 A0 10 00              ldy   #16
0444 7D69 5C A9 7E 02           jml   oBusyErr
0445 7D6D
0446 7D6D
0447 7D6D                       ENDP 
0448 7D6D
0449 7D6D
0450 7D6D              BusyErrs PROC EXPORT 
0451 7D6D
0452 7D6D                       EXPORT BusyErr0 
0453 7D6D                       EXPORT BusyErr2 
0454 7D6D                       EXPORT BusyErr4 
0455 7D6D                       EXPORT BusyErr6 
0456 7D6D                       EXPORT BusyErr8 
0457 7D6D                       EXPORT BusyErr10 
0458 7D6D                       EXPORT BusyErr12 
0459 7D6D                       EXPORT BusyErr14 
0460 7D6D                       EXPORT BusyErr16 
0461 7D6D
0462 7D6D
0463 7D6D
0464 7D6D              BusyErr0  
0465 7D6D A0 00 00              ldy   #0
0466 7D70 5C 6C 7E 02           jml   BusyErr
0467 7D74              BusyErr2  
0468 7D74 A0 02 00              ldy   #2
0469 7D77 5C 6C 7E 02           jml   BusyErr
0470 7D7B              BusyErr4  
0471 7D7B A0 04 00              ldy   #4
0472 7D7E 5C 6C 7E 02           jml   BusyErr
0473 7D82              BusyErr6  
0474 7D82 A0 06 00              ldy   #6
0475 7D85 5C 6C 7E 02           jml   BusyErr
0476 7D89              BusyErr8  
0477 7D89 A0 08 00              ldy   #8
0478 7D8C 5C 6C 7E 02           jml   BusyErr
0479 7D90              BusyErr10  
0480 7D90 A0 0A 00              ldy   #10
0481 7D93 5C 6C 7E 02           jml   BusyErr
0482 7D97              BusyErr12  
0483 7D97 A0 0C 00              ldy   #12
0484 7D9A 5C 6C 7E 02           jml   BusyErr
0485 7D9E              BusyErr14  
0486 7D9E A0 0E 00              ldy   #14
0487 7DA1 5C 6C 7E 02           jml   BusyErr
0488 7DA5              BusyErr16  
0489 7DA5 A0 10 00              ldy   #16
0490 7DA8 5C 6C 7E 02           jml   BusyErr
0491 7DAC
0492 7DAC
0493 7DAC                       ENDP 
0494 7DAC
0495 7DAC
0496 7DAC              NotImp   PROC EXPORT 
0497 7DAC A9 FF 04              lda   #$04FF
0498 7DAF 38                    sec   
0499 7DB0 6B                    rtl   
0500 7DB1                       ENDP 
0501 7DB1
0502 7DB1
0503 7DB1                       END   
